<?php

namespace Snapfile\Entities;

use Illuminate\Database\Eloquent\Model;

class ServiceType extends Model 
{

    protected $table = 'service_types';
    public $timestamps = true;
    protected $fillable = array('name', 'max_quote_respondents', 'accept_quote_as_lead_fee_cents', 'profile_type_id');
    protected $visible = array('name', 'max_quote_respondents', 'accept_quote_as_lead_fee_cents', 'profile_type_id');

    public function profileType()
    {
        return $this->belongsTo('Snapfile\Entities\ProfileType', 'profile_type_id');
    }

    public function profileFields()
    {
        return $this->belongsToMany('Snapfile\Entities\ProfileField', 'service_type_profile_fields');
    }

    public function fileTypes()
    {
        return $this->belongsToMany('Snapfile\Entities\FileType', 'service_type_file_types');
    }

}